package examples.integration.out_loan_ra;

import java.io.*;

import javax.resource.Referenceable;
import javax.resource.*;
import javax.resource.spi.*;
import javax.naming.Reference;
import javax.resource.cci.*;

public class ConnectionFactoryImpl implements ConnectionFactory, Serializable, Referenceable {

     private ManagedConnectionFactory manConnFactory;
     private ConnectionManager connManager;
     private Reference ref;

     public ConnectionFactoryImpl(ManagedConnectionFactory manConnFactory, ConnectionManager connManager) {

          System.out.println("ConnectionFactoryImpl(ManagedConnectionFactory manConnFactory, ConnectionManager connManager) called");

          this.manConnFactory = manConnFactory;

          this.connManager = connManager;
     }

     public javax.resource.cci.Connection getConnection() throws ResourceException {

          System.out.println("ConnectionFactoryImpl.getConnection() called");

          javax.resource.cci.Connection conn = null;

          conn = (javax.resource.cci.Connection) connManager.allocateConnection(manConnFactory, null);

          return conn;
     }

     public javax.resource.cci.Connection getConnection(ConnectionSpec cSpec)  throws ResourceException {

          System.out.println("ConnectionFactoryImpl.getConnection(ConnectionSpec cSpec) called");

          javax.resource.cci.Connection conn = null;

          ConnectionRequestInfo connRequestInfo = new ConnectionRequestInfoImpl();

          conn = (javax.resource.cci.Connection) connManager.allocateConnection(manConnFactory, connRequestInfo);

          return conn;
     }

     public ResourceAdapterMetaData getMetaData() throws ResourceException {

          return new ResourceAdapterMetaDataImpl();
     }
    
     public RecordFactory getRecordFactory() throws ResourceException {

          return new RecordFactoryImpl();
     }

    public void setReference(Reference ref) {

          this.ref = ref;
     }

     public Reference getReference() {

          return ref;
     }
}